// Version 1.01, 5/17/94
//	Used Wave/D instead of Wave in several places.

// Version 1.10, 12/31/95. Update for Igor Pro 3.0.
//	Got rid of /D which is no longer needed.

#pragma rtGlobals = 1

// DeletePointsXY(deleteMode, isParametric, theXWave, theYWave, startPoint, endPoint, minY, maxY)
//	Deletes points that fit criteria determined by deleteMode and checkMode
//	See DeleteMarqueeData for an explanation of deleteMode.
//	If isParametric is non-zero then theXWave is the wave against which theYWave is graphed.

Function DeletePointsXY(deleteMode, isParametric, theXWave, theYWave, startPoint, endPoint, minY, maxY)
	Variable deleteMode					// 1 for delete inside marquee, 2 for delete outside
	Variable isParametric
	Wave theXWave, theYWave
	Variable startPoint, endPoint
	Variable minY, maxY
	
	Variable numToCheck
	Variable p, numDeleted, deleteIt
	Variable val
	
	numDeleted = 0
	numToCheck = endPoint-startPoint+1
	if (numToCheck <= 0)
		return 0
	endif
	p = startPoint
	do
		val = theYWave[p]
		if (deleteMode == 1)
			deleteIt = (val >= minY) %& (val <= maxY)	// deleting inside points
		else	
			deleteIt = (val < minY) %| (val > maxY)		// deleting outside points
		endif
		if (deleteIt)
			DeletePoints p, 1, theYWave
			if (isParametric)
				DeletePoints p, 1, theXWave
			endif
			numDeleted += 1
		else
			p += 1
		endif
		numToCheck -= 1
	while (numToCheck > 0)
End

Function FDeleteMarqueeData(yWave, deleteMode, checkMode)
	Wave yWave
	Variable deleteMode			// 1 = delete inside marquee, 2 = delete outside marquee
	Variable checkMode			// 1 = check X values, 2 = check Y values, 3 = check X and Y values

	Variable minPoint, maxPoint, numToDeleteFromEnd, numDeleted, len
	Variable minY, maxY, val
	Variable isParametricPlot		// 1 if normal, 2 if parametric (XY)
	
	// find the wave against which yWave is plotted, if any
	WAVE/Z xWave = XWaveRefFromTrace("", NameOfWave(yWave))
	isParametricPlot = WaveExists(xWave)
	
	if (checkMode %& 1)						// do we care about X values ?
		GetMarquee bottom					// find horizontal marquee location is in terms of the bottom axis
		if (isParametricPlot)
			FindLevel/Q xWave, V_left
			if (V_Flag)
				minPoint = 0							// V_left is less than the smallest value in xWave
			else
				minPoint = x2pnt(xWave, V_LevelX)
			endif
			FindLevel/Q xWave, V_right
			if (V_Flag)
				maxPoint = numpnts(xWave)-1		// V_right is greater than the largest value in xWave
			else
				maxPoint = x2pnt(xWave, V_LevelX)
			endif
		else
			minPoint = x2pnt(yWave, V_left)
			maxPoint = x2pnt(yWave, V_right)
		endif
	else
		minPoint = 0
		maxPoint = numpnts(yWave)-1
	endif
	
	if (checkMode %& 2)				// do we care about Y values ?
		GetMarquee left				// find vertical marquee location is in terms of the left axis
		minY = V_bottom
		maxY = V_top
	endif
	
	if (checkMode == 1)				// are we checking just X values ?
		// Make sure that we are not trying to delete the entire wave
		if (deleteMode == 1)
			len = numpnts(yWave) - (maxPoint-minPoint+1)
		else
			len = maxPoint - minPoint - 1
		endif
	endif

	if (deleteMode == 1)			// deleting inside points ?
		if (checkMode == 1)		// we are checking X values only ?
			numDeleted = maxPoint-minPoint+1
			DeletePoints minPoint, numDeleted, yWave
			if (isParametricPlot)
				DeletePoints minPoint, numDeleted, xWave
			endif
			Printf "%d points deleted from %d to %d\r", numDeleted, minPoint, maxPoint
		endif
		if (checkMode %& 2)		// we need to check Y values ?
			len = numpnts(yWave)					// original number of points
			DeletePointsXY(deleteMode, isParametricPlot, xWave, yWave, minPoint, maxPoint, minY, maxY)
			numDeleted = len - numpnts(yWave)
			Printf "%d points deleted\r", numDeleted
		endif
	endif
	
	if (deleteMode == 2)			// deleting outside points ?
		numToDeleteFromEnd = numpnts(yWave) - maxPoint - 1
		if (checkMode == 1)		// we are checking X values only ?
			DeletePoints maxPoint+1, numToDeleteFromEnd, yWave
			DeletePoints 0, minPoint, yWave
			if (isParametricPlot)
				DeletePoints maxPoint+1, numToDeleteFromEnd, xWave
				DeletePoints 0, minPoint, xWave
			endif
			Printf "%d points deleted from start, %d points deleted from end\r", minPoint, numToDeleteFromEnd
		endif
		if (checkMode %& 2)		// we need to check Y values ?
			len = numpnts(yWave)					// original number of points
			if (checkMode == 2)						// checking Y values only ?
				DeletePointsXY(deleteMode, isParametricPlot, xWave, yWave, minPoint, maxPoint, minY, maxY)
			else										// checking X and Y values
				numToDeleteFromEnd = numpnts(yWave) - maxPoint - 1
				DeletePoints maxPoint+1, numToDeleteFromEnd, yWave
				if (isParametricPlot)
					DeletePoints maxPoint+1, numToDeleteFromEnd, xWave
				endif
				DeletePointsXY(deleteMode, isParametricPlot, xWave, yWave, minPoint, maxPoint, minY, maxY)
				DeletePoints 0, minPoint, yWave
				if (isParametricPlot)
					DeletePoints 0, minPoint, xWave
				endif
			endif
			numDeleted = len - numpnts(yWave)
			Printf "%d points deleted\r", numDeleted
		endif
	endif
	
	Printf "Length of data = %d\r", numpnts(yWave)
End

// DeleteMarqueeData(theYWave, deleteMode, checkMode)
//	This deletes points from the specified wave that is displayed against the
//	bottom/left axes of the active graph.
//
//	In its simplest form, the technique is to create a marquee in the graph that
//	encloses the points you want to delete and then run the macro. It will delete
//	the marqueed points.
//	To try this, do the following:
//		Make test=gnoise(1); Display test; Modify mode=2, lsize=3
//		(Now marquee some points and select DeleteMarqueeData from the Macros menu.)
//
//	There are several other ways to use it. These ways differ in the criteria
//	used to select which points will be deleted.
//		You can delete the points outside the marquee rather than inside.
//
//		You can delete points that fall inside or outside a given range of Y values,
//		regardless of their X values.
//
//		You can delete points that fall inside or outside a given range of X values,
//		regardless of their Y values. This is by far the fastest technique because it
//		does not have to search point by point.
//
//	The deleteMode and checkMode parameters determine the criteria used when
//	selecting points to delete.
//
//	If checkMode is 1, then only X values are tested.	(this will run quickly)
//	If checkMode is 2 then only Y values are tested.	(this can be very time consuming)
//	If checkMode is 3 then X and Y values are tested.	(this can be very time consuming)
//
//	deleteMode determines whether points inside the marquee or outside the marquee
//	will be deleted.
//	If deleteMode is 1 then inside points are deleted.
//	If deleteMode is 2 then outside points are deleted.
//
//	The macro assumes that the wave is sorted and increasing in the X direction.
//	If you are graphing an XY pair and if the X wave is not monotonically increasing,
//	use the Sort operation to sort it.

Menu "QRS"
	"Smooth Wave In Graph...",SmoothWaveInGraphDialog()
End

Function SmoothWaveInGraphDialog()
	String traceName
	Prompt traceName,"Wave",popup,TraceNameList("",";",1)
		//wave theWave
		//Prompt Ya,"Enter Y Wave",popup,TraceNameList("",";",1)
		//theWave= GetWavesDataFolder(TraceNameToWaveRef("",tracename),2)
	DoPrompt "Smooth Wave In Graph",traceName
	Wave w = TraceNameToWaveRef("", traceName)
	Smooth 5, w
	
End


Proc DeleteMarqueeData(traceName, deleteMode, checkMode) : GraphMarquee
	string traceName
	Prompt traceName,"Wave",popup,TraceNameList("",";",1)
	Variable deleteMode=NumVarOrDefault("root:Packages:'Delete Marquee Points':gDeleteMarqueeModeSave", 1)
	Prompt deleteMode, "Delete", popup, "Points Inside Marquee;Points Outside Marquee"
	Variable checkMode=NumVarOrDefault("root:Packages:'Delete Marquee Points':gDeleteMarqueeCheckModeSave", 3)
	Prompt checkMode, "Criteria for selecting points to delete", popup, "X Values;Y Values;X and Y Values"

	PauseUpdate; Silent 1
	traceName=GetWavesDataFolder(TraceNameToWaveRef("",tracename),2)
	// Save input parameters for next time
	NewDataFolder/O root:Packages
	NewDataFolder/O root:Packages:'Delete Marquee Points'
	Variable/G root:Packages:'Delete Marquee Points':gDeleteMarqueeModeSave = deleteMode
	Variable/G root:Packages:'Delete Marquee Points':gDeleteMarqueeCheckModeSave = checkMode
	
	FDeleteMarqueeData($tracename, deleteMode, checkMode)
End

Proc DoDeleteMarqueeData()
	if (WinType(WinName(0, -1)) != 1)			// check that target window is a graph
		Abort "The target window must be a graph"
	endif
	
	GetMarquee left									// check that a marquee is up
	if (V_Flag == 0)
		Abort "You must create a marquee before running this procedure"
	endif
	
	DeleteMarqueeData()
End

// Matrix of Conditions for DeleteMarqueeData
//	Parametric data
//		Delete Inside Points
//			Check X Values
//			Check Y Values
//			Check X and Y Values
//		Delete Outside Points
//			Check X Values
//			Check Y Values
//			Check X and Y Values
//	Normal data
//		Delete Inside Points
//			Check X Values
//			Check Y Values
//			Check X and Y Values
//		Delete Outside Points
//			Check X Values
//			Check Y Values
//			Check X and Y Values

